x, y = np.random.randn(2, 100)
H, xedges, yedges = np.histogram2d(x, y, bins=(5, 8))
H.shape, xedges.shape, yedges.shape
# ((5, 8), (6,), (9,))

# We can now use the Matplotlib to visualize this 2-dimensional histogram:

extent = [yedges[0], yedges[-1], xedges[-1], xedges[0]]
import matplotlib.pyplot as plt
plt.imshow(H, extent=extent, interpolation='nearest')
# <matplotlib.image.AxesImage object at ...>
plt.colorbar()
# <matplotlib.colorbar.Colorbar instance at ...>
plt.show()
